<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Jet Theme Sample Data for Magento 2 (System)
 */

namespace Amasty\JetThemeSampleData\Setup;

use Amasty\Base\Helper\Deploy;
use Exception;
use Magento\Framework\Setup\SampleData\InstallerInterface;

class Installer
{
    /**
     * @var InstallerInterface[]
     */
    private $installerList;

    /**
     * @var Deploy
     */
    private $pubDeploy;

    /**
     * @param Deploy $pubDeploy
     * @param array $installerList
     */
    public function __construct(
        Deploy $pubDeploy,
        array $installerList = []
    ) {
        $this->pubDeploy = $pubDeploy;
        $this->installerList = $installerList;
    }

    public function install(): void
    {
        $this->deployPubData();

        $installerList = $this->getInstallerList();
        foreach ($installerList as $installer) {
            $installer->install();
        }
    }

    /**
     * @return void
     */
    private function deployPubData(): void
    {
        $pubPath = __DIR__ . '/../pub';
        $this->pubDeploy->deployFolder($pubPath);
    }

    /**
     * @return InstallerInterface[]
     * @throws Exception
     */
    private function getInstallerList(): array
    {
        $installerList = [];
        usort($this->installerList, [$this, 'compare']);
        foreach ($this->installerList as $installerKey => $installerData) {
            if (!is_array($installerData) || !array_key_exists('installer', $installerData)) {
                throw new Exception('Installer Must have installer Property.');
            }

            $installer = $installerData['installer'] ?? null;
            if (!$installer instanceof InstallerInterface) {
                throw new Exception('Installer Class Must Implement InstallerInterface.');
            }

            $installerList[] = $installer;
        }

        $this->installerList = $installerList;

        return $this->installerList;
    }

    /**
     * @param array $a
     * @param array $b
     *
     * @return int
     */
    private function compare(array $a, array $b): int
    {
        $aOrder = (int)($a['order'] ?? 0);
        $bOrder = (int)($b['order'] ?? 0);

        return $aOrder <=> $bOrder;
    }
}
