<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Jet Theme Sample Data for Magento 2 (System)
 */

namespace Amasty\JetThemeSampleData\Setup\Fixtures;

use Amasty\CustomTabs\Api\TabsRepositoryInterface;
use Amasty\CustomTabs\Model\Tabs\TabsFactory;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\File\Csv;
use Magento\Framework\Module\Manager;
use Magento\Framework\ObjectManagerInterface;
use Magento\Framework\Setup\SampleData\Context as SampleDataContext;
use Magento\Framework\Setup\SampleData\FixtureManager;
use Magento\Framework\Setup\SampleData\InstallerInterface;
use Magento\SalesSampleData;

class ProductTabs implements InstallerInterface
{
    /**
     * @var FixtureManager
     */
    private $fixtureManager;

    /**
     * @var Csv
     */
    private $csvReader;

    /**
     * @var ObjectManagerInterface
     */
    private $objectManager;

    /**
     * @var Manager
     */
    private $moduleManager;

    public function __construct(
        Manager $moduleManager,
        SampleDataContext $sampleDataContext,
        ObjectManagerInterface $objectManager
    ) {
        $this->fixtureManager = $sampleDataContext->getFixtureManager();
        $this->csvReader = $sampleDataContext->getCsvReader();
        $this->objectManager = $objectManager;
        $this->moduleManager = $moduleManager;
    }

    /**
     * @return void
     */
    public function install(): void
    {
        if ($this->moduleManager->isEnabled('Amasty_CustomTabs')) {
            $this->process(['Amasty_JetThemeSampleData::fixtures/ProductTabs/product_tabs.csv']);
        }
    }

    /**
     * @param array $fixtures
     * @throws LocalizedException
     */
    private function process(array $fixtures): void
    {
        $tabsRepository = $this->objectManager->create(TabsRepositoryInterface::class);
        $tabsFactory = $this->objectManager->get(TabsFactory::class);
        foreach ($fixtures as $fileName) {
            $fileName = $this->fixtureManager->getFixture($fileName);
            if (!file_exists($fileName)) {
                continue;
            }

            $rows = $this->csvReader->getData($fileName);
            $header = array_shift($rows);

            foreach ($rows as $row) {
                $data = [];
                foreach ($row as $key => $value) {
                    $data[$header[$key]] = trim($value);
                }

                $model = $tabsFactory->create();
                $model->addData($data);
                $tabsRepository->save($model);
            }
        }
    }
}
