<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Jet Theme Sample Data for Magento 2 (System)
 */


namespace Amasty\JetThemeSampleData\Setup\Fixtures;

use Magento\CatalogSampleData\Model\Attribute;
use Magento\CatalogSampleData\Model\Category;
use Magento\DownloadableSampleData\Model\Product;
use Magento\DownloadableSampleData\Setup\Installer;
use Magento\Framework\App\ObjectManager;
use Magento\Framework\Setup;
use Magento\DownloadableSampleData;
use Magento\Framework\Setup\SampleData\InstallerInterface;
use Magento\Store\Model\Store;
use Magento\Store\Model\StoreManagerInterface;

class Downloadable extends Installer implements InstallerInterface
{

    /**
     * @var Category
     */
    protected $category;

    /**
     * @var Attribute
     */
    private $attribute;

    /**
     * @var Product
     */
    private $downloadableProduct;

    /**
     * @var StoreManagerInterface
     */
    private $storeManager;

    /**
     * @param Category  $category
     * @param Attribute $attribute
     * @param Product   $product
     * @param StoreManagerInterface $storeManager
     */
    public function __construct(
        Category $category,
        Attribute $attribute,
        Product $product,
        StoreManagerInterface $storeManager = null
    ) {
        $this->category = $category;
        $this->attribute = $attribute;
        $this->downloadableProduct = $product;
        $this->storeManager = $storeManager ?: ObjectManager::getInstance()->get(StoreManagerInterface::class);
    }

    /**
     * @return void
     */
    public function install(): void
    {
        $this->storeManager->setCurrentStore(Store::DISTRO_STORE_ID);
        $this->downloadableProduct->install(
            ['Amasty_JetThemeSampleData::fixtures/Downloadable/products_download.csv'],
            ['Amasty_JetThemeSampleData::fixtures/Downloadable/images_video.csv'],
            ['Amasty_JetThemeSampleData::fixtures/Downloadable/downloadable_data.csv']
        );
    }
}
