<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Jet Theme Sample Data for Magento 2 (System)
 */

namespace Amasty\JetThemeSampleData\Setup\Fixtures;

use Amasty\JetThemeSampleData\Setup\Config\Converter\ConfigConverterInterface;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\File\Csv;
use Magento\Framework\Setup\SampleData\Context as SampleDataContext;
use Magento\Framework\Setup\SampleData\FixtureManager;
use Magento\Framework\Setup\SampleData\InstallerInterface;
use Magento\Framework\App\Config\Storage\WriterInterface;
use Magento\SalesSampleData;

class Config implements InstallerInterface
{
    /**
     * @var FixtureManager
     */
    private $fixtureManager;

    /**
     * @var Csv
     */
    private $csvReader;

    /**
     * @var WriterInterface
     */
    private $configWriter;

    /**
     * @var ConfigConverterInterface[]
     */
    private $converters;

    public function __construct(
        SampleDataContext $sampleDataContext,
        WriterInterface $configWriter,
        array $converters = []
    ) {
        $this->fixtureManager = $sampleDataContext->getFixtureManager();
        $this->csvReader = $sampleDataContext->getCsvReader();
        $this->converters = $converters;
        $this->configWriter = $configWriter;
    }

    /**
     * @return void
     */
    public function install(): void
    {
        $this->process(['Amasty_JetThemeSampleData::fixtures/Config/config.csv']);
    }

    /**
     * @param array $fixtures
     * @throws LocalizedException
     */
    private function process(array $fixtures): void
    {
        foreach ($fixtures as $fileName) {
            $fileName = $this->fixtureManager->getFixture($fileName);
            if (!file_exists($fileName)) {
                continue;
            }

            $rows = $this->csvReader->getData($fileName);
            $header = array_shift($rows);

            foreach ($rows as $row) {
                $data = [];
                foreach ($row as $key => $value) {
                    $data[$header[$key]] = trim($value);
                }

                $value = isset($this->converters[$data['path']])
                    ? $this->converters[$data['path']]->convert($data['value']) : $data['value'];
                $this->configWriter->save(
                    $data['path'],
                    $value,
                    $data['scope'],
                    $data['scope_id']
                );
            }
        }
    }
}
