<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Jet Theme Sample Data for Magento 2 (System)
 */

namespace Amasty\JetThemeSampleData\Setup\Fixtures;

use Magento\CatalogSampleData\Model\Category;
use Magento\CmsSampleData;
use Magento\CmsSampleData\Model\Block;
use Magento\CmsSampleData\Model\Page;
use Magento\CmsSampleData\Setup\Installer;
use Magento\Framework\Setup\SampleData\InstallerInterface;
use Magento\ThemeSampleData\Model\Css;

class Cms extends Installer implements InstallerInterface
{
    /**
     * @var Category
     */
    private $category;

    /**
     * @var Css
     */
    private $css;

    /**
     * @var Page
     */
    private $page;

    /**
     * @var Block
     */
    private $block;

    /**
     * @param Category $category
     * @param Css $css
     * @param Page $page
     * @param Block $block
     */
    public function __construct(
        Category $category,
        Css $css,
        Page $page,
        Block $block
    ) {
        $this->category = $category;
        $this->css = $css;
        $this->page = $page;
        $this->block = $block;
    }

    /**
     * @return void
     */
    public function install(): void
    {
        $this->page->install(['Amasty_JetThemeSampleData::fixtures/Cms/pages/pages.csv']);
        $this->block->install(
            [
                'Amasty_JetThemeSampleData::fixtures/Cms/blocks/categories_static_blocks.csv'
            ]
        );
    }
}
