<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Jet Theme Sample Data for Magento 2 (System)
 */

namespace Amasty\JetThemeSampleData\Setup\Fixtures;

use Exception;
use Magento\CatalogSampleData;
use Magento\CatalogSampleData\Model\Attribute;
use Magento\CatalogSampleData\Model\Category;
use Magento\CatalogSampleData\Model\Product;
use Magento\CatalogSampleData\Setup\Installer;
use Magento\Eav\Model\Config as EavConfig;
use Magento\Framework\App\ResourceConnection;
use Magento\Framework\Setup\SampleData\InstallerInterface;

class Catalog extends Installer implements InstallerInterface
{
    /**
     * @var EavConfig
     */
    private $eavConfig;

    /**
     * @var ResourceConnection
     */
    private $resourceConnection;

    /**
     * @param Category $categorySetup
     * @param Attribute $attributeSetup
     * @param Product $productSetup
     * @param EavConfig $eavConfig
     * @param ResourceConnection $resourceConnection
     */
    public function __construct(
        Category $categorySetup,
        Attribute $attributeSetup,
        Product $productSetup,
        EavConfig $eavConfig,
        ResourceConnection $resourceConnection
    ) {
        $this->eavConfig = $eavConfig;
        $this->resourceConnection = $resourceConnection;
        parent::__construct($categorySetup, $attributeSetup, $productSetup);
    }

    /**
     * @throws Exception
     */
    public function install(): void
    {
        $this->attributeSetup->install(['Amasty_JetThemeSampleData::fixtures/Catalog/attributes.csv']);
        $this->categorySetup->install(['Amasty_JetThemeSampleData::fixtures/Catalog/categories.csv']);

        $this->fixDishVariablesAttribute();
    }

    /**
     * @return void
     */
    private function fixDishVariablesAttribute(): void
    {
        try {
            $attribute = $this->eavConfig->getAttribute('catalog_product', 'dish_variation');
            $attribute->setData('swatch_input_type', 'text');
            $attribute->save();
            foreach ($attribute->getOptions() as $option) {
                if (!$option['value']) {
                    continue;
                }

                $this->resourceConnection->getConnection()->insert(
                    $this->resourceConnection->getTableName('eav_attribute_option_swatch'),
                    [
                        'option_id' => $option['value'],
                        'store_id' => 0,
                        'value' => $option['label']
                    ]
                );

                $this->resourceConnection->getConnection()->insert(
                    $this->resourceConnection->getTableName('eav_attribute_option_swatch'),
                    [
                        'option_id' => $option['value'],
                        'store_id' => 1,
                        'value' => $option['label']
                    ]
                );
            }
        } catch (Exception $e) {
            return;
        }
    }
}
