<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Jet Theme Sample Data for Magento 2 (System)
 */

namespace Amasty\JetThemeSampleData\Setup\Config\Converter;

use Magento\Cms\Model\Block;
use Magento\Cms\Model\BlockFactory;

class CmsBlockCodeToId implements ConfigConverterInterface
{
    /**
     * @var BlockFactory
     */
    private $blockFactory;

    public function __construct(BlockFactory $blockFactory)
    {
        $this->blockFactory = $blockFactory;
    }

    /**
     * @param string $value
     * @return mixed
     */
    public function convert(string $value)
    {
        /** @var Block $block */
        $block = $this->blockFactory->create()->load($value, 'identifier');
        if (!$block) {
            return null;
        }

        return $block->getId() ?: null;
    }
}
