<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Jet Theme Sample Data for Magento 2 (System)
 */

namespace Amasty\JetThemeSampleData\Console\Command;

use Amasty\JetThemeSampleData\Setup\Installer;
use Amasty\JetThemeSampleData\Setup\Prepare;
use Magento\Framework\App\Area;
use Magento\Framework\App\State;
use Magento\Framework\Console\Cli;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

class SampleDataDeployCommand extends Command
{
    public const CLEAN_OPTION = 'clean';

    /**
     * @var Installer
     */
    private $installer;

    /**
     * @var Prepare
     */
    private $prepareInstall;

    /**
     * @var State
     */
    private $appState;

    public function __construct(
        Installer $installer,
        Prepare $prepareInstall,
        State $appState
    ) {
        $this->installer = $installer;
        $this->prepareInstall = $prepareInstall;
        $this->appState = $appState;
        parent::__construct();
    }

    protected function configure(): void
    {
        $this->setName('jettheme:sampledata:deploy');
        $this->setDescription('Deploy sample data modules for Amasty Jet Theme');
        $this->addOption(
            self::CLEAN_OPTION,
            null,
            InputOption::VALUE_NONE,
            'Clean database from default sampledata'
        );

        parent::configure();
    }

    protected function execute(InputInterface $input, OutputInterface $output): int
    {
        $output->writeln("Start Deploying Jet Theme Sample Data");
        if ($input->getOption(self::CLEAN_OPTION)) {
            $this->prepareInstall->prepare();
        }

        $this->appState->emulateAreaCode(Area::AREA_GLOBAL, [$this->installer, 'install']);
        $output->writeln('Sampledata Deployed');

        return Cli::RETURN_SUCCESS;
    }
}
