<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Jet Theme Backend for Magento 2 (System)
 */

namespace Amasty\JetTheme\ViewModel;

use Magento\Framework\View\Element\Block\ArgumentInterface;
use Magento\Framework\Serialize\SerializerInterface;
use Magento\Wishlist\Helper\Data;
use Magento\Catalog\Api\ProductTypeListInterface;

class WishlistViewModel implements ArgumentInterface
{
    /**
     * @var Data
     */
    private $wishlistData;

    /**
     * @var ProductTypeListInterface
     */
    private $productTypeList;

    /**
     * @var SerializerInterface
     */
    private $serializer;

    public function __construct(
        Data $wishlistData,
        SerializerInterface $serializer,
        ProductTypeListInterface $productTypeList
    ) {
        $this->wishlistData = $wishlistData;
        $this->serializer = $serializer;
        $this->productTypeList = $productTypeList;
    }

    public function isAllowWishlist(): bool
    {
        return $this->wishlistData->isAllow();
    }

    public function getProductTypeJson(): string
    {
        return $this->serializer->serialize(['productType' => $this->getProductTypes()]);
    }

    private function getProductTypes(): array
    {
        return array_map(function ($productType) {
            return $productType->getName();
        }, $this->productTypeList->getProductTypes());
    }
}
