<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Jet Theme Backend for Magento 2 (System)
 */

namespace Amasty\JetTheme\ViewModel\Search;

use Magento\CatalogSearch\Helper\Data;
use Magento\Framework\View\Element\Block\ArgumentInterface;

class ResultViewModel implements ArgumentInterface
{
    /**
     * Catalog search data
     *
     * @var Data
     */
    protected $catalogSearchData;

    public function __construct(
        Data $catalogSearchData
    ) {
        $this->catalogSearchData = $catalogSearchData;
    }

    /**
     * Get search query text
     *
     * @return string
     */
    public function getQueryText(): string
    {
        return $this->catalogSearchData->getEscapedQueryText();
    }
}
