<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Jet Theme Backend for Magento 2 (System)
 */

namespace Amasty\JetTheme\ViewModel\Logo;

use Amasty\JetTheme\Model\ConfigProvider;
use Magento\Framework\UrlInterface;
use Magento\Framework\View\Element\Block\ArgumentInterface;
use Magento\Store\Model\StoreManagerInterface;

class LogoViewModel implements ArgumentInterface
{
    /**
     * @var ConfigProvider
     */
    private $configProvider;

    /**
     * @var StoreManagerInterface
     */
    private $storeManager;

    public function __construct(
        ConfigProvider $configProvider,
        StoreManagerInterface $storeManager
    ) {
        $this->configProvider = $configProvider;
        $this->storeManager = $storeManager;
    }

    /**
     * @return bool
     */
    public function isOtherMobileLogo(): bool
    {
        return $this->configProvider->isOtherMobileLogo();
    }

    /**
     * @return string|null
     */
    public function getMobileLogoUrl(): ?string
    {
        $baseFolderUrl = $this->storeManager->getStore()->getBaseUrl(UrlInterface::URL_TYPE_MEDIA);
        $baseFolderUrl .= 'amasty/jet_theme/mobile_logo/';
        $mobileLogoPath = $this->configProvider->getMobileLogoPath();

        return $mobileLogoPath ? $baseFolderUrl . $mobileLogoPath : null;
    }

    /**
     * @return string|null
     */
    public function getMobileLogoAttributeWidth(): ?string
    {
        return $this->configProvider->getMobileLogoAttributeWidth();
    }

    /**
     * @return string|null
     */
    public function getMobileLogoAttributeHeight(): ?string
    {
        return $this->configProvider->getMobileLogoAttributeHeight();
    }
}
