<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Jet Theme Backend for Magento 2 (System)
 */

namespace Amasty\JetTheme\ViewModel\Header;

use Amasty\JetTheme\Model\ConfigProvider;
use Magento\Framework\View\Element\Block\ArgumentInterface;

class HeaderViewModel implements ArgumentInterface
{
    /**
     * @var ConfigProvider
     */
    private $configProvider;

    public function __construct(
        ConfigProvider $configProvider
    ) {
        $this->configProvider = $configProvider;
    }

    /**
     * @return bool
     */
    public function isCustomHeaderEnabled(): bool
    {
        return $this->configProvider->isCustomHeaderEnabled();
    }

    /**
     * @return int
     */
    public function getHeaderWidth(): int
    {
        return $this->configProvider->getHeaderWidth();
    }
}
