<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Jet Theme Backend for Magento 2 (System)
 */

namespace Amasty\JetTheme\ViewModel;

use Amasty\JetTheme\Api\Data\FooterLinkInterface;
use Amasty\JetTheme\Model\FooterLink\FooterLinkProvider;
use Magento\Framework\View\Element\Block\ArgumentInterface;

class FooterLinkViewModel implements ArgumentInterface
{
    /**
     * @var FooterLinkProvider
     */
    private $footerLinkProvider;

    public function __construct(FooterLinkProvider $footerLinkProvider)
    {
        $this->footerLinkProvider = $footerLinkProvider;
    }

    /**
     * @return FooterLinkInterface[]
     */
    public function getFooterLinks(): array
    {
        return $this->footerLinkProvider->getFooterLinksForCurrentStore();
    }
}
