<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Jet Theme Backend for Magento 2 (System)
 */

namespace Amasty\JetTheme\ViewModel\Checkout;

use Amasty\JetTheme\Model\ConfigProvider;
use Magento\Framework\View\Element\Block\ArgumentInterface;
use Magento\Quote\Model\Quote\Item;

class CartViewModel implements ArgumentInterface
{
    /**
     * @var ConfigProvider
     */
    private $configProvider;

    public function __construct(
        ConfigProvider $configProvider
    ) {
        $this->configProvider = $configProvider;
    }

    /**
     * @return bool
     */
    public function isShowSpecialPriceOnCartPage(): bool
    {
        return $this->configProvider->isShowSpecialPriceOnCartPage();
    }

    /**
     * @param Item $item
     * @return bool
     */
    public function hasSpecialPrice(Item $item): bool
    {
        if ($item->getProduct()->getSpecialPrice()) {
            return true;
        }

        if ($item->getProductType() == 'configurable') {
            foreach ($item->getChildren() as $child) {
                if ($child->getProduct()->getSpecialPrice()) {
                    return true;
                }
            }
        }

        return false;
    }

    /**
     * @return string
     */
    public function getQuantitySelectorType(): string
    {
        return $this->configProvider->getQuantitySelectorType();
    }
}
