<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Jet Theme Backend for Magento 2 (System)
 */

namespace Amasty\JetTheme\Ui\Component\Listing;

use Amasty\JetTheme\Model\FooterLink\ResourceModel\FooterLink\Grid\CollectionFactory;
use Magento\Framework\View\Element\UiComponent\DataProvider\DataProvider;

class FooterLinkDataProvider extends DataProvider
{
    /**
     * @return array
     */
    public function getData(): array
    {
        $data = parent::getData();
        if ($data['totalRecords'] > 0) {
            foreach ($data['items'] as &$item) {
                $item['stores'] = explode(',', $item['stores']);
            }
        }

        return $data;
    }
}
