<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Jet Theme Backend for Magento 2 (System)
 */

namespace Amasty\JetTheme\Setup\Patch\Data;

use Amasty\JetTheme\Api\Data\FooterLinkInterface;
use Amasty\JetTheme\Api\Data\FooterLinkInterfaceFactory;
use Amasty\JetTheme\Api\FooterLinkRepositoryInterface;
use Magento\Framework\Setup\Patch\DataPatchInterface;

class MigrateFooterLink implements DataPatchInterface
{
    /**
     * @var FooterLinkInterfaceFactory
     */
    private $footerLinkFactory;

    /**
     * @var FooterLinkRepositoryInterface
     */
    private $footerLinkRepository;

    /**
     * @var string[]
     */
    private $defaultFooterLinks = [
        'Privacy and Cookie Policy' => 'privacy-policy-cookie-restriction-mode',
        'Orders and Returns' => 'sales/guest/form',
        'Search Terms' => 'search/term/popular',
        'Advanced Search' => 'catalogsearch/advanced',
        'Contact Us' => 'contact',
    ];

    /**
     * @param FooterLinkInterfaceFactory $footerLinkFactory
     * @param FooterLinkRepositoryInterface $footerLinkRepository
     */
    public function __construct(
        FooterLinkInterfaceFactory $footerLinkFactory,
        FooterLinkRepositoryInterface $footerLinkRepository
    ) {
        $this->footerLinkFactory = $footerLinkFactory;
        $this->footerLinkRepository = $footerLinkRepository;
    }

    /**
     * @return array
     */
    public function getAliases(): array
    {
        return [];
    }

    /**
     * @return string[]
     */
    public static function getDependencies(): array
    {
        return [];
    }

    /**
     * @inerhitDoc
     */
    public function apply(): self
    {
        $sortOrder = 0;
        foreach ($this->defaultFooterLinks as $label => $path) {
            /** @var FooterLinkInterface $footerLink */
            $footerLink = $this->footerLinkFactory->create();
            $footerLink->setTitle($label);
            $footerLink->setPath($path);
            $footerLink->setStatus(FooterLinkInterface::STATUS_ENABLED);
            $footerLink->setSortOrder($sortOrder++);
            $footerLink->setStores([0]);
            $this->footerLinkRepository->save($footerLink);
        }

        return $this;
    }
}
