<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Jet Theme Backend for Magento 2 (System)
 */

namespace Amasty\JetTheme\Plugin\Wishlist\CustomerData\Wishlist;

use Magento\Wishlist\CustomerData\Wishlist;
use Magento\Wishlist\Helper\Data;
use Magento\Wishlist\Model\Item;

class AddProductIds
{
    private const LIMIT_PRODUCTS = 100;

    /**
     * @var Data
     */
    private $wishlistHelper;

    public function __construct(Data $wishlistHelper)
    {
        $this->wishlistHelper = $wishlistHelper;
    }

    public function afterGetSectionData(Wishlist $subject, array $result): array
    {
        $collection = $this->wishlistHelper->getWishlistItemCollection();
        $collection->clear()->setPageSize(self::LIMIT_PRODUCTS)
            ->setInStockFilter(true)->setOrder('added_at');

        $productIds = [];
        /** @var Item $wishlistItem */
        foreach ($collection as $wishlistItem) {
            $productIds[] = $wishlistItem->getProductId();
        }

        $result['product_ids'] = $productIds;

        return $result;
    }
}
