<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Jet Theme Backend for Magento 2 (System)
 */

namespace Amasty\JetTheme\Plugin\Widget\Model\Widget\Instance;

use Amasty\JetTheme\Model\StoreThemeMapper;
use Magento\Widget\Model\Widget\Instance;

class ReplaceContainer
{
    /**
     * @var array
     */
    private $containerMap;

    /**
     * @var StoreThemeMapper
     */
    private $storeThemeMapper;

    public function __construct(
        StoreThemeMapper $storeThemeMapper,
        array $containerMap = []
    ) {
        $this->containerMap = $containerMap;
        $this->storeThemeMapper = $storeThemeMapper;
    }

    /**
     * @param Instance $subject
     * @param string $container
     * @param string $templatePath
     * @return array
     */
    public function beforeGenerateLayoutUpdateXml(Instance $subject, $container, $templatePath = ''): array
    {
        if (isset($this->containerMap[$container])
            && $this->storeThemeMapper->isThemeJetThemeById((int)$subject->getThemeId())) {
            $container = $this->containerMap[$container];
        }

        return [$container, $templatePath];
    }
}
