<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Jet Theme Backend for Magento 2 (System)
 */

namespace Amasty\JetTheme\Plugin\Magento\Ui\Block\Wrapper;

use Magento\Ui\Block\Wrapper as UiWidget;
use Amasty\JetTheme\ViewModel\Catalog\Ajax as AjaxViewModel;

class AddAjaxViewModelToUiWidget
{
    /**
     * @var AjaxViewModel
     */
    private $ajaxViewModel;

    public function __construct(AjaxViewModel $ajaxViewModel)
    {
        $this->ajaxViewModel = $ajaxViewModel;
    }

    /**
     * @param UiWidget $productsList
     * @return void
     */
    public function beforeToHtml(UiWidget $productsList): void
    {
        $productsList->setData('ajax_view_model', $this->ajaxViewModel);
    }
}
