<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Jet Theme Backend for Magento 2 (System)
 */

namespace Amasty\JetTheme\Plugin\Magento\Setup\Model;

use Amasty\JetTheme\Model\AssetManager;
use Magento\Framework\App\Area;
use Magento\Framework\App\State;
use Magento\Setup\Model\DeclarationInstaller;
use Psr\Log\LoggerInterface;

class GenerateThemeAsset
{
    /**
     * @var AssetManager
     */
    private $assetManager;

    /**
     * @var State
     */
    private $state;

    /**
     * @var LoggerInterface
     */
    private $logger;

    public function __construct(
        AssetManager $assetsManager,
        State $state,
        LoggerInterface $logger
    ) {
        $this->assetManager = $assetsManager;
        $this->state = $state;
        $this->logger = $logger;
    }

    /**
     * @param DeclarationInstaller $subject
     * @param $result
     */
    public function afterInstallSchema(DeclarationInstaller $subject, $result): void
    {
        try {
            $this->state->emulateAreaCode(
                Area::AREA_FRONTEND,
                [$this->assetManager, 'generate']
            );
        } catch (\Exception $e) {
            $this->logger->critical($e);
        }
    }
}
