<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Jet Theme Backend for Magento 2 (System)
 */

namespace Amasty\JetTheme\Plugin\Magento\Checkout\Block\Cart;

use Magento\Checkout\Block\Cart\Crosssell as CrossselBlock;
use Amasty\JetTheme\ViewModel\Catalog\Ajax as AjaxViewModel;

class AddAjaxViewModelToCrosssell
{
    /**
     * @var AjaxViewModel
     */
    private $ajaxViewModel;

    public function __construct(AjaxViewModel $ajaxViewModel)
    {
        $this->ajaxViewModel = $ajaxViewModel;
    }

    /**
     * @param CrossselBlock $crossselBlock
     * @return void
     */
    public function beforeToHtml(CrossselBlock $crossselBlock): void
    {
        if (!$crossselBlock->getData('ajax_view_model')) {
            $crossselBlock->setData('ajax_view_model', $this->ajaxViewModel);

        }
    }
}
