<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Jet Theme Backend for Magento 2 (System)
 */

namespace Amasty\JetTheme\Plugin\Magento\CatalogWidget\Block\Product;

use Magento\CatalogWidget\Block\Product\ProductsList as ProductsList;
use Amasty\JetTheme\ViewModel\Catalog\Ajax as AjaxViewModel;

class AddAjaxViewModelToProductList
{
    /**
     * @var AjaxViewModel
     */
    private $ajaxViewModel;

    public function __construct(AjaxViewModel $ajaxViewModel)
    {
        $this->ajaxViewModel = $ajaxViewModel;
    }

    /**
     * @param ProductsList $productsList
     * @return void
     */
    public function beforeToHtml(ProductsList $productsList): void
    {
        $productsList->setData('ajax_view_model', $this->ajaxViewModel);
    }
}
