<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Jet Theme Backend for Magento 2 (System)
 */

namespace Amasty\JetTheme\Plugin\Magento\Catalog\Block\Product\Widget\NewWidget;

use Magento\Catalog\Block\Product\Widget\NewWidget as NewWidget;
use Amasty\JetTheme\ViewModel\Catalog\Ajax as AjaxViewModel;

class AddAjaxViewModelToNewWidget
{
    /**
     * @var AjaxViewModel
     */
    private $ajaxViewModel;

    public function __construct(AjaxViewModel $ajaxViewModel)
    {
        $this->ajaxViewModel = $ajaxViewModel;
    }

    /**
     * @param NewWidget $productsList
     * @return void
     */
    public function beforeToHtml(NewWidget $productsList): void
    {
        $productsList->setData('ajax_view_model', $this->ajaxViewModel);
    }
}
