<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Jet Theme Backend for Magento 2 (System)
 */

namespace Amasty\JetTheme\Observer;

use Amasty\JetTheme\Model\AssetManager;
use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;

class GenerateThemeAsset implements ObserverInterface
{
    /**
     * @var AssetManager
     */
    private $assetManager;

    public function __construct(AssetManager $assetsManager)
    {
        $this->assetManager = $assetsManager;
    }

    /**
     * @param Observer $observer
     */
    public function execute(Observer $observer): void
    {
        $this->assetManager->generate();
    }
}
