<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Jet Theme Backend for Magento 2 (System)
 */

namespace Amasty\JetTheme\Model\TransferConfigProcessor;

interface TransferConfigInterface
{
    /**
     * Process styles config
     *
     * @return string
     */
    public function process(): string;

    /**
     * @return string
     */
    public function getFileNameToProcess(): string;

    /**
     * @param int|null $storeId
     * @return bool
     */
    public function isValidToProcess(?int $storeId): bool;
}
