<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Jet Theme Backend for Magento 2 (System)
 */

namespace Amasty\JetTheme\Model\TransferConfigProcessor;

use Amasty\JetTheme\Model\Config\Source\Fonts\FontType;
use Amasty\JetTheme\Model\ConfigProvider;

class NonLatinFont implements TransferConfigInterface
{
    public const OUTPUT_LESS_FILE = 'css/source/_fonts-system.less';
    public const TEMPLATE_FILE = '_non-latin-fonts-system.template';

    /**
     * @var FileProcessor
     */
    private $fileProcessor;

    /**
     * @var ConfigProvider
     */
    private $configProvider;

    public function __construct(
        FileProcessor $fileProcessor,
        ConfigProvider $configProvider
    ) {
        $this->fileProcessor = $fileProcessor;
        $this->configProvider = $configProvider;
    }

    /**
     * Process styles config
     *
     * @return string
     */
    public function process(): string
    {
        return $this->fileProcessor->processFile(self::TEMPLATE_FILE);
    }

    public function getFileNameToProcess(): string
    {
        return self::OUTPUT_LESS_FILE;
    }

    /**
     * @param int|null $storeId
     * @return bool
     */
    public function isValidToProcess(?int $storeId): bool
    {
        return $this->configProvider->getFontType($storeId) == FontType::NON_LATIN;
    }
}
