<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Jet Theme Backend for Magento 2 (System)
 */

namespace Amasty\JetTheme\Model\Template\Filter;

use Magento\Framework\Filter\DirectiveProcessorInterface;
use Magento\Framework\Filter\Template;

class IfCustomDirective implements DirectiveProcessorInterface
{
    public const PATTERN = '/{{ifCustom \s*(.*?)}}\s(.*?)({{elseCustom}}(.*?))?{{\/ifCustom\s*}}/si';

    /**
     * @param string[] $construction condition matches
     * @param Template $filter
     * @param array $templateVariables
     * @return string
     */
    public function process(array $construction, Template $filter, array $templateVariables): string
    {
        $value = '';
        if ($construction[1]) {
            $value = $construction[2];
        } elseif (isset($construction[3], $construction[4])) {
            $value = $construction[4];
        }

        return $value;
    }

    /**
     * @return string
     */
    public function getRegularExpression(): string
    {
        return self::PATTERN;
    }
}
