<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Jet Theme Backend for Magento 2 (System)
 */

namespace Amasty\JetTheme\Model\Style\Color;

use Magento\Framework\Data\OptionSourceInterface;

class IconsColor implements OptionSourceInterface
{
    public const DARK = 'dark';
    public const LIGHT = 'light';
    public const LIGHT_GREEN = 'light_green';

    /**
     * @return array
     */
    public function toOptionArray(): array
    {
        return [
            ['value' => self::DARK, 'label' => __('Dark')],
            ['value' => self::LIGHT, 'label' => __('Light')],
            ['value' => self::LIGHT_GREEN, 'label' => __('Light Green')],
        ];
    }
}
