<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Jet Theme Backend for Magento 2 (System)
 */

namespace Amasty\JetTheme\Model\OptionSource;

use Amasty\JetTheme\Model\SocialLink\SvgProvider;
use Magento\Framework\Data\OptionSourceInterface;

class SocialImages implements OptionSourceInterface
{
    /**
     * @var SvgProvider
     */
    private $svgProvider;

    public function __construct(SvgProvider $svgProvider)
    {
        $this->svgProvider = $svgProvider;
    }

    /**
     * @var array
     */
    private $options = [];

    /**
     * @return array|null
     */
    public function toOptionArray(): array
    {
        if (!$this->options) {
            foreach ($this->svgProvider->getAllSvg() as $key => $svg) {
                $this->options[] = [
                    'value' => $key,
                    'label' => $svg
                ];
            }
        }

        return $this->options;
    }
}
