<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Jet Theme Backend for Magento 2 (System)
 */

namespace Amasty\JetTheme\Model\OptionSource;

use Magento\Framework\Data\OptionSourceInterface;

class DisplayOptions implements OptionSourceInterface
{
    public const HOVER = 'hover';
    public const ALWAYS = 'always';

    /**
     * @var array|null
     */
    private $options;

    /**
     * @return array
     */
    public function toOptionArray(): array
    {
        if (!$this->options) {
            $this->options = [
                ['value' => self::HOVER, 'label' => __('On Hover')],
                ['value' => self::ALWAYS, 'label' => __('Always')],
            ];
        }

        return $this->options;
    }
}
