<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Jet Theme Backend for Magento 2 (System)
 */

namespace Amasty\JetTheme\Model\FooterLink\ResourceModel\FooterLink\Grid;

use Amasty\JetTheme\Api\Data\FooterLinkInterface;
use Amasty\JetTheme\Model\FooterLink\ResourceModel\FooterLink;
use Amasty\JetTheme\Model\FooterLink\StoresTrait;
use Magento\Framework\Data\Collection\Db\FetchStrategyInterface as FetchStrategy;
use Magento\Framework\Data\Collection\EntityFactoryInterface as EntityFactory;
use Magento\Framework\DB\Helper;
use Magento\Framework\Event\ManagerInterface as EventManager;
use Magento\Framework\View\Element\UiComponent\DataProvider\SearchResult;
use Psr\Log\LoggerInterface;

class Collection extends SearchResult
{
    use StoresTrait;

    /**
     * @var array
     */
    private $storeConfig = [
        'stores' => FooterLinkInterface::STORES,
        'entityId' => FooterLinkInterface::ENTITY_ID,
        'storeTableName' => FooterLinkInterface::STORE_TABLE_NAME,
        'storeIdField' => FooterLinkInterface::STORE_FOOTER_STORE_ID_FIELD,
        'entityIdField' => FooterLinkInterface::STORE_FOOTER_ID_FIELD,
    ];

    /**
     * @var Helper
     */
    private $dbHelper;

    public function __construct(
        EntityFactory $entityFactory,
        LoggerInterface $logger,
        FetchStrategy $fetchStrategy,
        EventManager $eventManager,
        Helper $dbHelper,
        $mainTable = FooterLinkInterface::TABLE_NAME,
        $resourceModel = FooterLink::class
    ) {
        parent::__construct($entityFactory, $logger, $fetchStrategy, $eventManager, $mainTable, $resourceModel);
        $this->dbHelper = $dbHelper;
    }

    /**
     * Set resource model and determine field mapping
     *
     * @return void
     */
    protected function _construct()
    {
        $this->_map['fields']['stores'] = 'stores.store_id';
        parent::_construct();
    }

    /**
     * @inheritdoc
     */
    protected function _renderFiltersBefore()
    {
        $this->joinStores();
        parent::_renderFiltersBefore();
    }
}
