<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Jet Theme Backend for Magento 2 (System)
 */

namespace Amasty\JetTheme\Model\FooterLink\ResourceModel\FooterLink;

use Amasty\JetTheme\Api\Data\FooterLinkInterface;
use Amasty\JetTheme\Model\FooterLink\FooterLink;
use Amasty\JetTheme\Model\FooterLink\ResourceModel\FooterLink as FooterLinkResource;
use Amasty\JetTheme\Model\FooterLink\StoresTrait;
use Magento\Framework\Data\Collection\Db\FetchStrategyInterface;
use Magento\Framework\Data\Collection\EntityFactoryInterface;
use Magento\Framework\DB\Adapter\AdapterInterface;
use Magento\Framework\DB\Helper;
use Magento\Framework\Event\ManagerInterface;
use Magento\Framework\Model\ResourceModel\Db\AbstractDb;
use Magento\Framework\Model\ResourceModel\Db\Collection\AbstractCollection;
use Psr\Log\LoggerInterface;

class Collection extends AbstractCollection
{
    use StoresTrait;

    /**
     * @var array
     */
    private $storeConfig = [
        'stores' => FooterLinkInterface::STORES,
        'entityId' => FooterLinkInterface::ENTITY_ID,
        'storeTableName' => FooterLinkInterface::STORE_TABLE_NAME,
        'storeIdField' => FooterLinkInterface::STORE_FOOTER_STORE_ID_FIELD,
        'entityIdField' => FooterLinkInterface::STORE_FOOTER_ID_FIELD,
    ];

    /**
     * @var string
     */
    protected $_idFieldName = 'entity_id';

    /**
     * @var Helper
     */
    private $dbHelper;

    public function __construct(
        EntityFactoryInterface $entityFactory,
        LoggerInterface $logger,
        FetchStrategyInterface $fetchStrategy,
        ManagerInterface $eventManager,
        Helper $dbHelper,
        AdapterInterface $connection = null,
        AbstractDb $resource = null
    ) {
        parent::__construct($entityFactory, $logger, $fetchStrategy, $eventManager, $connection, $resource);
        $this->dbHelper = $dbHelper;
    }

    /**
     * @return void
     */
    protected function _construct()
    {
        $this->_init(
            FooterLink::class,
            FooterLinkResource::class
        );
    }

    /**
     * @return Collection
     */
    protected function _beforeLoad()
    {
        $this->joinStores();

        return parent::_beforeLoad();
    }
}
