<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Jet Theme Backend for Magento 2 (System)
 */

namespace Amasty\JetTheme\Model\FooterLink\ResourceModel;

use Amasty\JetTheme\Api\Data\FooterLinkInterface;
use Amasty\JetTheme\Model\FooterLink\StoresTrait;
use Magento\Framework\DB\Helper;
use Magento\Framework\Model\AbstractModel;
use Magento\Framework\Model\ResourceModel\Db\AbstractDb;
use Magento\Framework\Model\ResourceModel\Db\Context;

class FooterLink extends AbstractDb
{
    use StoresTrait;

    /**
     * @var array
     */
    private $storeConfig = [
        'stores' => FooterLinkInterface::STORES,
        'entityId' => FooterLinkInterface::ENTITY_ID,
        'storeTableName' => FooterLinkInterface::STORE_TABLE_NAME,
        'storeIdField' => FooterLinkInterface::STORE_FOOTER_STORE_ID_FIELD,
        'entityIdField' => FooterLinkInterface::STORE_FOOTER_ID_FIELD,
    ];

    /**
     * @var Helper
     */
    private $dbHelper;

    public function __construct(
        Helper $dbHelper,
        Context $context,
        $connectionName = null
    ) {
        parent::__construct($context, $connectionName);
        $this->dbHelper = $dbHelper;
    }

    /**
     * @return void
     */
    protected function _construct()
    {
        $this->_init(FooterLinkInterface::TABLE_NAME, FooterLinkInterface::ENTITY_ID);
    }

    /**
     * @param AbstractModel $object
     */
    protected function _afterSave(AbstractModel $object)
    {
        $this->updateStores($object);

        return parent::_afterSave($object);
    }
}
