<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Jet Theme Backend for Magento 2 (System)
 */

namespace Amasty\JetTheme\Model\FooterLink;

use Amasty\JetTheme\Api\Data\FooterLinkInterface;
use Amasty\JetTheme\Api\FooterLinkRepositoryInterface;
use Magento\Framework\Api\SearchCriteriaBuilderFactory;
use Magento\Framework\Api\SortOrderBuilder;
use Magento\Store\Model\StoreManagerInterface;

class FooterLinkProvider
{
    /**
     * @var FooterLinkRepositoryInterface
     */
    private $footerLinkRepository;

    /**
     * @var SearchCriteriaBuilderFactory
     */
    private $searchCriteriaBuilderFactory;

    /**
     * @var SortOrderBuilder
     */
    private $sortOrderBuilder;

    /**
     * @var StoreManagerInterface
     */
    private $storeManager;

    public function __construct(
        FooterLinkRepositoryInterface $footerLinkRepository,
        SearchCriteriaBuilderFactory $searchCriteriaBuilderFactory,
        SortOrderBuilder $sortOrderBuilder,
        StoreManagerInterface $storeManager
    ) {
        $this->footerLinkRepository = $footerLinkRepository;
        $this->searchCriteriaBuilderFactory = $searchCriteriaBuilderFactory;
        $this->sortOrderBuilder = $sortOrderBuilder;
        $this->storeManager = $storeManager;
    }

    /**
     * @return FooterLinkInterface[]
     */
    public function getFooterLinksForCurrentStore(): array
    {
        $sortOrder = $this->sortOrderBuilder->setField('sort_order')->setDirection('ASC')->create();
        $searchCriteria = $this->searchCriteriaBuilderFactory->create()
            ->addFilter(FooterLinkInterface::STATUS, 1)
            ->addFilter(
                FooterLinkInterface::STORE_FOOTER_STORE_ID_FIELD,
                [0, $this->storeManager->getStore()->getId()],
                'in'
            )
            ->setSortOrders([$sortOrder])->create();

        return $this->footerLinkRepository->getList($searchCriteria)->getItems();
    }
}
