<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Jet Theme Backend for Magento 2 (System)
 */

namespace Amasty\JetTheme\Model\FooterLink;

use Amasty\JetTheme\Api\Data\FooterLinkInterface;
use Magento\Framework\Model\AbstractModel;

class FooterLink extends AbstractModel implements FooterLinkInterface
{
    /**
     * @inheritdoc
     */
    protected function _construct()
    {
        $this->_init(ResourceModel\FooterLink::class);
    }

    /**
     * @return string|null
     */
    public function getId()
    {
        return $this->getData(self::ENTITY_ID);
    }

    /**
     * @param int|string $entityId
     * @return FooterLinkInterface
     */
    public function setId($entityId): FooterLinkInterface
    {
        return $this->setData(self::ENTITY_ID, $entityId);
    }

    /**
     * @return string|null
     */
    public function getTitle(): ?string
    {
        return $this->getData(self::TITLE);
    }

    /**
     * @param string $title
     * @return FooterLinkInterface
     */
    public function setTitle(string $title): FooterLinkInterface
    {
        return $this->setData(self::TITLE, $title);
    }

    /**
     * @return string|null
     */
    public function getPath(): ?string
    {
        return $this->getData(self::PATH);
    }

    /**
     * @param string $path
     * @return FooterLinkInterface
     */
    public function setPath(string $path): FooterLinkInterface
    {
        return $this->setData(self::PATH, $path);
    }

    /**
     * @return int|null
     */
    public function getStatus(): ?int
    {
        return (int) $this->getData(self::STATUS);
    }

    /**
     * @param int $status
     * @return FooterLinkInterface
     */
    public function setStatus(int $status): FooterLinkInterface
    {
        return $this->setData(self::STATUS, $status);
    }

    /**
     * @return int|null
     */
    public function getSortOrder(): ?int
    {
        return $this->getData(self::SORT_ORDER) !== null ? (int)$this->getData(self::SORT_ORDER) : null;
    }

    /**
     * @param int $sortOrder
     * @return FooterLinkInterface
     */
    public function setSortOrder(int $sortOrder): FooterLinkInterface
    {
        return $this->setData(self::SORT_ORDER, $sortOrder);
    }

    /**
     * @return array|null
     */
    public function getStores(): ?array
    {
        if ($this->getData(self::STORES) === null) {
            return null;
        }

        return is_array($this->getData(self::STORES))
            ? $this->getData(self::STORES)
            : explode(',', $this->getData(self::STORES));
    }

    /**
     * @param array $stores
     * @return FooterLinkInterface
     */
    public function setStores(array $stores): FooterLinkInterface
    {
        return $this->setData(self::STORES, $stores);
    }
}
