<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Jet Theme Backend for Magento 2 (System)
 */

namespace Amasty\JetTheme\Model\FooterLink;

use Amasty\JetTheme\Api\FooterLinkRepositoryInterface;
use Amasty\JetTheme\Model\FooterLink\ResourceModel\FooterLink\CollectionFactory;
use Magento\Framework\App\RequestInterface;
use Magento\Ui\DataProvider\AbstractDataProvider;

class DataProvider extends AbstractDataProvider
{
    /**
     * @var FooterLinkRepositoryInterface
     */
    private $footerLinkRepository;

    /**
     * @var RequestInterface
     */
    private $request;

    public function __construct(
        FooterLinkRepositoryInterface $footerLinkRepository,
        RequestInterface $request,
        CollectionFactory $collectionFactory,
        $name,
        $primaryFieldName,
        $requestFieldName,
        array $meta = [],
        array $data = []
    ) {
        parent::__construct($name, $primaryFieldName, $requestFieldName, $meta, $data);
        $this->collection = $collectionFactory->create();
        $this->footerLinkRepository = $footerLinkRepository;
        $this->request = $request;
    }

    /**
     * @return array
     * @throws \Magento\Framework\Exception\NoSuchEntityException
     */
    public function getData(): array
    {
        if ($footerLinkId = $this->request->getParam($this->getRequestFieldName())) {
            $data = $this->footerLinkRepository->get((int)$footerLinkId)->getData();

            return [$footerLinkId => $data];
        }

        return [];
    }
}
