<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Jet Theme Backend for Magento 2 (System)
 */

namespace Amasty\JetTheme\Model\Config\Source\ProductPage;

use Magento\Framework\Data\OptionSourceInterface;

class ThumbnailsPosition implements OptionSourceInterface
{
    public const BOTTOM = 'bottom';
    public const LEFT = 'left';
    public const RIGHT = 'right';

    /**
     * @return array
     */
    public function toOptionArray(): array
    {
        return [
            ['value' => self::BOTTOM, 'label' => __('Bottom')],
            ['value' => self::LEFT, 'label' => __('Left')],
            ['value' => self::RIGHT, 'label' => __('Right')],
        ];
    }
}
