<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Jet Theme Backend for Magento 2 (System)
 */

namespace Amasty\JetTheme\Model\Config\Source\ProductPage;

use Magento\Framework\Data\OptionSourceInterface;

class StickyAddToCart implements OptionSourceInterface
{
    public const DISABLED = 0;
    public const SIDEBAR = 'sidebar';
    public const HORIZONTAL = 'horizontal';

    /**
     * @return array
     */
    public function toOptionArray(): array
    {
        return [
            ['value' => self::DISABLED, 'label' => __('Disabled')],
            ['value' => self::SIDEBAR, 'label' => __('Sidebar')],
            ['value' => self::HORIZONTAL, 'label' => __('Horizontal Bar')],
        ];
    }
}
