<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Jet Theme Backend for Magento 2 (System)
 */

namespace Amasty\JetTheme\Model\Config\Source\ProductPage;

use Magento\Framework\Data\OptionSourceInterface;

class RoundSquare implements OptionSourceInterface
{
    public const ROUND = 'round';
    public const SQUARE = 'square';

    /**
     * @return array
     */
    public function toOptionArray(): array
    {
        return [
            ['value' => self::ROUND, 'label' => __('Round')],
            ['value' => self::SQUARE, 'label' => __('Square')],
        ];
    }
}
