<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Jet Theme Backend for Magento 2 (System)
 */

namespace Amasty\JetTheme\Model\Config\Source\ProductPage;

use Magento\Framework\Data\OptionSourceInterface;

class AddToCartPosition implements OptionSourceInterface
{
    public const ON_LINE = 'on-line';
    public const UNDER = 'under';

    /**
     * @return array
     */
    public function toOptionArray(): array
    {
        return [
            ['value' => self::ON_LINE, 'label' => __('On the line with the quantity selector')],
            ['value' => self::UNDER, 'label' => __('Under the quantity selector')],
        ];
    }
}
