<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Jet Theme Backend for Magento 2 (System)
 */

namespace Amasty\JetTheme\Model\Config\Source\Newsletter;

use Magento\Framework\Data\OptionSourceInterface;

class TextPosition implements OptionSourceInterface
{
    public const INLINE = 'inline';
    public const BEFORE_INPUT = 'before-input';
    public const AFTER_INPUT = 'after-input';

    /**
     * @return array
     */
    public function toOptionArray(): array
    {
        return [
            ['value' => self::INLINE, 'label' => __('Inline')],
            ['value' => self::BEFORE_INPUT, 'label' => __('Before Input')],
            ['value' => self::AFTER_INPUT, 'label' => __('After Input')],
        ];
    }
}
