<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Jet Theme Backend for Magento 2 (System)
 */

namespace Amasty\JetTheme\Model\Config\Source\Newsletter;

use Magento\Framework\Data\OptionSourceInterface;

class FormPosition implements OptionSourceInterface
{
    public const LEFT = 'left';
    public const RIGHT = 'right';
    public const CENTER = 'center';

    /**
     * @return array
     */
    public function toOptionArray(): array
    {
        return [
            ['value' => self::LEFT, 'label' => __('Left')],
            ['value' => self::RIGHT, 'label' => __('Right')],
            ['value' => self::CENTER, 'label' => __('Center')],
        ];
    }
}
