<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Jet Theme Backend for Magento 2 (System)
 */

namespace Amasty\JetTheme\Model\Config\Source\CategoryPage;

use Magento\Framework\Data\OptionSourceInterface;

class SwatchDisplayType implements OptionSourceInterface
{
    public const HOVER = 'hover';
    public const ALWAYS = 'always';
    /**
     * @return array
     */
    public function toOptionArray(): array
    {
        return [
            ['value' => self::HOVER, 'label' => __('Hover')],
            ['value' => self::ALWAYS, 'label' => __('Always')],
        ];
    }
}
