<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Jet Theme Backend for Magento 2 (System)
 */

namespace Amasty\JetTheme\Model\Config\Source\CategoryPage;

use Magento\Framework\Data\OptionSourceInterface;

class ProductPerLineDesktop implements OptionSourceInterface
{
    public const TWO = 2;
    public const THREE = 3;
    public const FOUR = 4;

    /**
     * @return array
     */
    public function toOptionArray(): array
    {
        return [
            ['value' => self::TWO, 'label' => 2],
            ['value' => self::THREE, 'label' => 3],
            ['value' => self::FOUR, 'label' => 4],
        ];
    }
}
