<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Jet Theme Backend for Magento 2 (System)
 */

namespace Amasty\JetTheme\Model\Config\Source\CategoryPage;

use Magento\Framework\Data\OptionSourceInterface;

class ProductName implements OptionSourceInterface
{
    public const DEFAULT = 'default';
    public const ALL_CAPS = 'uppercase';
    public const ALL_LOWER_CASE = 'lowercase';
    public const TITLE_CASE = 'capitalize';

    /**
     * @return array
     */
    public function toOptionArray(): array
    {
        return [
            ['value' => self::DEFAULT, 'label' => __('Default')],
            ['value' => self::ALL_CAPS, 'label' => __('All Caps')],
            ['value' => self::ALL_LOWER_CASE, 'label' => __('All Lower Case')],
            ['value' => self::TITLE_CASE, 'label' => __('Each Word with the Capital Letter')],
        ];
    }
}
