<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Jet Theme Backend for Magento 2 (System)
 */

namespace Amasty\JetTheme\Model\Config\Source\CategoryPage;

use Magento\Framework\Data\OptionSourceInterface;

class DisplayAddToCart implements OptionSourceInterface
{
    public const NO = 'none';
    public const ALWAYS = 'always';
    public const HOVER = 'hover';

    /**
     * @return array
     */
    public function toOptionArray(): array
    {
        return [
            ['value' => self::NO, 'label' => __('No')],
            ['value' => self::ALWAYS, 'label' => __('Always')],
            ['value' => self::HOVER, 'label' => __('On Hover')],
        ];
    }
}
