<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Jet Theme Backend for Magento 2 (System)
 */

namespace Amasty\JetTheme\Model\Config\Source\CategoryPage;

use Magento\Framework\Data\OptionSourceInterface;

class AlignAddToCart implements OptionSourceInterface
{
    public const CENTER = 'center';
    public const LEFT = 'left';
    public const FULL_WIDTH = 'full-width';

    /**
     * @return array
     */
    public function toOptionArray(): array
    {
        return [
            ['value' => self::CENTER, 'label' => __('Center')],
            ['value' => self::LEFT, 'label' => __('Left')],
            ['value' => self::FULL_WIDTH, 'label' => __('Full Width')],
        ];
    }
}
