<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Jet Theme Backend for Magento 2 (System)
 */

namespace Amasty\JetTheme\Model;

class AttributeLoader
{
    /**
     * @param array $xmlArray
     * @param string $globalTagName
     * @return array
     */
    public function loadAttributes(array $xmlArray, string $globalTagName): array
    {
        $resultAttributes = [];
        $attributesData = [];
        foreach ($xmlArray['config']['_value'][$globalTagName] as $attributes) {
            foreach ($attributes as $attribute) {
                $attribute = array_key_exists('item', $attribute) ? $attribute['item'] : $attribute;
                foreach ($attribute as $itemData) {
                    $attributesData[$itemData['_attribute']['name']] = $itemData['_value'];
                }
                $resultAttributes[$attributesData['identifier']] = $attributesData;
            }
        }

        return $resultAttributes;
    }
}
