<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Jet Theme Backend for Magento 2 (System)
 */

namespace Amasty\JetTheme\Block\Html\Header;

use Magento\Framework\ObjectManagerInterface;
use Magento\Framework\View\Element\Template\Context;
use Magento\MediaStorage\Helper\File\Storage\Database;
use Magento\Theme\Block\Html\Header\Logo as MagentoLogo;

/**
 * Magento 2.3 compatibility. Remover it after stops support
 */
class Logo extends MagentoLogo
{
    public function __construct(
        Context $context,
        Database $fileStorageHelper,
        ObjectManagerInterface $objectManager,
        array $data = []
    ) {
        parent::__construct($context, $fileStorageHelper, $data);
        if ($this->getData('logoPathResolver') === null
            && class_exists(\Magento\Theme\ViewModel\Block\Html\Header\LogoPathResolver::class)) {
            $this->setData(
                'logoPathResolver',
                $objectManager->create(\Magento\Theme\ViewModel\Block\Html\Header\LogoPathResolver::class)
            );
        }

        if ($this->getData('logo_size_resolver') === null
            && class_exists(\Magento\Theme\ViewModel\Block\Html\Header\LogoSizeResolver::class)) {
            $this->setData(
                'logo_size_resolver',
                $objectManager->create(\Magento\Theme\ViewModel\Block\Html\Header\LogoSizeResolver::class)
            );
        }
    }
}
