<?php

declare(strict_types=1);

/**
 * @author Amasty Team
 * @copyright Copyright (c) Amasty (https://www.amasty.com)
 * @package Jet Theme Backend for Magento 2 (System)
 */

namespace Amasty\JetTheme\Api;

use Amasty\JetTheme\Api\Data\FooterLinkInterface;
use Magento\Framework\Api\SearchCriteriaInterface;
use Magento\Framework\Api\SearchResults;
use Magento\Framework\Exception\LocalizedException;
use Magento\Framework\Exception\NoSuchEntityException;

interface FooterLinkRepositoryInterface
{
    /**
     * @param FooterLinkInterface $footerLink
     * @return FooterLinkInterface
     * @throws LocalizedException
     */
    public function save(FooterLinkInterface $footerLink): FooterLinkInterface;

    /**
     * @param int $footerLinkId
     * @return FooterLinkInterface
     * @throws NoSuchEntityException
     */
    public function get(int $footerLinkId): FooterLinkInterface;

    /**
     * @param SearchCriteriaInterface $searchCriteria
     * @return SearchResults
     * @throws LocalizedException
     */
    public function getList(SearchCriteriaInterface $searchCriteria): SearchResults;

    /**
     * @param FooterLinkInterface $footerLink
     * @return bool true on success
     * @throws LocalizedException
     */
    public function delete(FooterLinkInterface $footerLink): bool;

    /**
     * @param int $footerLinkId
     * @return bool true on success
     * @throws NoSuchEntityException
     * @throws LocalizedException
     */
    public function deleteById(int $footerLinkId): bool;
}
